/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class MacAddressApplet
extends Applet {
    public static String sep = ":";
    public static String format = "%02X";

    public static String macToString(NetworkInterface ni) throws SocketException {
        return MacAddressApplet.macToString(ni, sep, format);
    }

    public static String macToString(NetworkInterface ni, String separator, String format) throws SocketException {
        byte[] mac = ni.getHardwareAddress();
        if (mac != null) {
            StringBuffer macAddress = new StringBuffer("");
            String sep = "";
            for (byte o : mac) {
                macAddress.append(sep).append(String.format(format, o));
                sep = separator;
            }
            return macAddress.toString();
        }
        return null;
    }

    public static String getMacAddress() {
        String mac = "";
        try {
            String strJavaVersion = System.getProperty("java.version");
            if (strJavaVersion.startsWith("1.5")) {
                return "Improper vesion";
            }
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                mac = MacAddressApplet.macToString(nis.nextElement());
                if (mac == null) continue;
                return mac;
            }
            return null;
        }
        catch (SocketException ex) {
            mac = "SocketException:: " + ex.toString();
            return mac;
        }
        catch (Exception ex) {
            mac = "Exception:: " + ex.toString();
            return mac;
        }
    }
}

