/*
 * Decompiled with CFR 0.152.
 */
package crypto.des;

import java.io.IOException;
import java.io.InputStream;

public class Utils {
    public static int read(InputStream in, byte[] b, int off, int len) throws IOException {
        int i;
        if (len <= 0) {
            return 0;
        }
        int c = in.read();
        if (c == -1) {
            return -1;
        }
        if (b != null) {
            b[off] = (byte)c;
        }
        for (i = 1; i < len && (c = in.read()) != -1; ++i) {
            if (b == null) continue;
            b[off + i] = (byte)c;
        }
        return i;
    }

    public static int readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        int r;
        for (int l = 0; l < len; l += r) {
            r = Utils.read(in, b, l, len - l);
            if (r != -1) continue;
            return -1;
        }
        return len;
    }

    public static boolean even(long n) {
        return (n & 1L) == 0L;
    }

    public static boolean odd(long n) {
        return (n & 1L) != 0L;
    }

    public static int countOnes(byte n) {
        return Utils.countOnes((long)n & 0xFFL);
    }

    public static int countOnes(int n) {
        return Utils.countOnes((long)n & 0xFFFFFFFFL);
    }

    public static int countOnes(long n) {
        int count = 0;
        while (n != 0L) {
            if (Utils.odd(n)) {
                ++count;
            }
            n >>>= 1;
        }
        return count;
    }
}

