/*
 * Decompiled with CFR 0.152.
 */
package crypto.des;

public class CryptoUtils {
    public static void zeroBlock(byte[] block, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            block[i] = 0;
        }
    }

    public static void zeroBlock(byte[] block) {
        CryptoUtils.zeroBlock(block, 0, block.length);
    }

    public static void xorBlock(byte[] a, int aOff, byte[] b, int bOff, byte[] dst, int dstOff, int len) {
        for (int i = 0; i < len; ++i) {
            dst[dstOff + i] = (byte)(a[aOff + i] ^ b[bOff + i]);
        }
    }

    public static void xorBlock(byte[] a, byte[] b, byte[] dst) {
        CryptoUtils.xorBlock(a, 0, b, 0, dst, 0, a.length);
    }

    public static void copyBlock(byte[] src, int srcOff, byte[] dst, int dstOff, int len) {
        for (int i = 0; i < len; ++i) {
            dst[dstOff + i] = src[srcOff + i];
        }
    }

    public static void copyBlock(byte[] src, byte[] dst) {
        CryptoUtils.copyBlock(src, 0, dst, 0, src.length);
    }

    public static boolean equalsBlock(byte[] a, int aOff, byte[] b, int bOff, int len) {
        for (int i = 0; i < len; ++i) {
            if (a[aOff + i] == b[bOff + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsBlock(byte[] a, byte[] b) {
        return CryptoUtils.equalsBlock(a, 0, b, 0, a.length);
    }

    public static void fillBlock(byte[] block, int blockOff, byte b, int len) {
        for (int i = blockOff; i < blockOff + len; ++i) {
            block[i] = b;
        }
    }

    public static void fillBlock(byte[] block, byte b) {
        CryptoUtils.fillBlock(block, 0, b, block.length);
    }

    public static void squashBytesToInts(byte[] inBytes, int inOff, int[] outInts, int outOff, int intLen) {
        for (int i = 0; i < intLen; ++i) {
            outInts[outOff + i] = (inBytes[inOff + i * 4] & 0xFF) << 24 | (inBytes[inOff + i * 4 + 1] & 0xFF) << 16 | (inBytes[inOff + i * 4 + 2] & 0xFF) << 8 | inBytes[inOff + i * 4 + 3] & 0xFF;
        }
    }

    public static void spreadIntsToBytes(int[] inInts, int inOff, byte[] outBytes, int outOff, int intLen) {
        for (int i = 0; i < intLen; ++i) {
            outBytes[outOff + i * 4] = (byte)(inInts[inOff + i] >>> 24);
            outBytes[outOff + i * 4 + 1] = (byte)(inInts[inOff + i] >>> 16);
            outBytes[outOff + i * 4 + 2] = (byte)(inInts[inOff + i] >>> 8);
            outBytes[outOff + i * 4 + 3] = (byte)inInts[inOff + i];
        }
    }

    public static void squashBytesToShorts(byte[] inBytes, int inOff, int[] outShorts, int outOff, int shortLen) {
        for (int i = 0; i < shortLen; ++i) {
            outShorts[outOff + i] = (inBytes[inOff + i * 2] & 0xFF) << 8 | inBytes[inOff + i * 2 + 1] & 0xFF;
        }
    }

    public static void spreadShortsToBytes(int[] inShorts, int inOff, byte[] outBytes, int outOff, int shortLen) {
        for (int i = 0; i < shortLen; ++i) {
            outBytes[outOff + i * 2] = (byte)(inShorts[inOff + i] >>> 8);
            outBytes[outOff + i * 2 + 1] = (byte)inShorts[inOff + i];
        }
    }

    public static String toStringBlock(byte[] block, int off, int len) {
        String hexits = "0123456789abcdef";
        StringBuffer buf = new StringBuffer();
        for (int i = off; i < off + len; ++i) {
            buf.append(hexits.charAt(block[i] >>> 4 & 0xF));
            buf.append(hexits.charAt(block[i] & 0xF));
        }
        return "[" + buf + "]";
    }

    public static String toStringBlock(byte[] block) {
        return CryptoUtils.toStringBlock(block, 0, block.length);
    }
}

