/*
 * Decompiled with CFR 0.152.
 */
package crypto.des;

import crypto.des.BlockCipher;
import crypto.des.CryptoPayloadLengthException;

public class CbcBlockCipher
extends BlockCipher {
    private BlockCipher blockCipher;
    private byte[] iv;
    private byte[] temp;

    public CbcBlockCipher(BlockCipher blockCipher) {
        super(blockCipher.keySize(), blockCipher.blockSize());
        this.blockCipher = blockCipher;
        this.iv = new byte[this.blockSize()];
        CbcBlockCipher.zeroBlock(this.iv);
        this.temp = new byte[this.blockSize()];
    }

    public void setKey(byte[] key) {
        this.blockCipher.setKey(key);
    }

    public void setIv(byte[] iv) {
        CbcBlockCipher.copyBlock(iv, this.iv);
    }

    public void encrypt(byte[] clearText, int clearOff, byte[] cipherText, int cipherOff) {
        CbcBlockCipher.xorBlock(clearText, clearOff, this.iv, 0, this.temp, 0, this.blockSize);
        this.blockCipher.encrypt(this.temp, 0, cipherText, cipherOff);
        CbcBlockCipher.copyBlock(cipherText, cipherOff, this.iv, 0, this.blockSize);
    }

    public void decrypt(byte[] cipherText, int cipherOff, byte[] clearText, int clearOff) {
        this.blockCipher.decrypt(cipherText, cipherOff, this.temp, 0);
        CbcBlockCipher.xorBlock(this.temp, 0, this.iv, 0, clearText, clearOff, this.blockSize);
        CbcBlockCipher.copyBlock(cipherText, cipherOff, this.iv, 0, this.blockSize);
    }

    private int getCipherTextLength(byte[] rawData) {
        int iMod = rawData.length % this.blockSize;
        int iDestLength = rawData.length;
        if (iMod != 0) {
            iDestLength += this.blockSize - iMod;
        }
        return iDestLength;
    }

    public byte[] encrypt(byte[] clearText) throws CryptoPayloadLengthException {
        if (clearText.length % this.blockSize != 0) {
            throw new CryptoPayloadLengthException("Invalid encryption paylod length");
        }
        byte[] cipherText = new byte[this.blockSize];
        byte[] byDestination = new byte[this.getCipherTextLength(clearText)];
        byte[] block = new byte[this.blockSize];
        int byteCount = 0;
        for (int i = 0; i < clearText.length; ++i) {
            block[byteCount++] = clearText[i];
            if ((i + 1) % this.blockSize != 0) continue;
            byteCount = 0;
            this.encrypt(block, 0, cipherText, 0);
            System.arraycopy(cipherText, 0, byDestination, i - this.blockSize + 1, this.blockSize);
        }
        return byDestination;
    }

    public byte[] decrypt(byte[] cipherText) throws CryptoPayloadLengthException {
        if (cipherText.length % this.blockSize != 0) {
            throw new CryptoPayloadLengthException("Invalid decryption paylod length");
        }
        byte[] clearText = new byte[this.blockSize];
        byte[] byDestination = new byte[this.getCipherTextLength(cipherText)];
        byte[] block = new byte[this.blockSize];
        int byteCount = 0;
        for (int i = 0; i < cipherText.length; ++i) {
            block[byteCount++] = cipherText[i];
            if ((i + 1) % this.blockSize != 0) continue;
            byteCount = 0;
            this.decrypt(block, 0, clearText, 0);
            System.arraycopy(clearText, 0, byDestination, i - this.blockSize + 1, this.blockSize);
        }
        return byDestination;
    }
}

