/*
 * Decompiled with CFR 0.152.
 */
package crypto;

import crypto.des.CbcBlockCipher;
import crypto.des.Des3Cipher;
import crypto.des.DesCipher;

public final class DESCrypto {
    private static DESCrypto instance = null;

    public static DESCrypto getInstance() {
        if (instance == null) {
            instance = new DESCrypto();
        }
        return instance;
    }

    private static void setOddParity(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            bytes[i] = (byte)(b & 0xFE | (b >> 1 ^ b >> 2 ^ b >> 3 ^ b >> 4 ^ b >> 5 ^ b >> 6 ^ b >> 7 ^ 1) & 1);
        }
    }

    private static byte[] xor(byte[] byData, byte xorValue) {
        byte[] byXOR = new byte[byData.length];
        for (int i = 0; i < byData.length; ++i) {
            byXOR[i] = (byte)(byData[i] ^ xorValue);
        }
        return byXOR;
    }

    private static byte[] crypto(boolean bEncryt, byte[] byKey, byte[] rawData) throws Exception {
        byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byte[] byFullKey = new byte[24];
        if (byKey.length == 16) {
            System.arraycopy(byKey, 0, byFullKey, 0, byKey.length);
            System.arraycopy(byKey, 0, byFullKey, byKey.length, 8);
        } else {
            byFullKey = byKey;
        }
        Des3Cipher engine = new Des3Cipher(byFullKey);
        CbcBlockCipher cipher = new CbcBlockCipher(engine);
        cipher.setIv(iv);
        if (bEncryt) {
            return cipher.encrypt(rawData);
        }
        return cipher.decrypt(rawData);
    }

    private static byte[] retailMAC(byte[] byKey, byte[] rawData) throws Exception {
        byte[] key1 = new byte[8];
        byte[] key2 = new byte[8];
        byte[] key3 = new byte[8];
        byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        System.arraycopy(byKey, 0, key1, 0, 8);
        System.arraycopy(byKey, 8, key2, 0, 8);
        System.arraycopy(byKey, 0, key3, 0, 8);
        DesCipher engine = new DesCipher(key1);
        CbcBlockCipher cipher = new CbcBlockCipher(engine);
        cipher.setIv(iv);
        byte[] byClearText = cipher.encrypt(rawData);
        byte[] byLast8Byte = new byte[8];
        System.arraycopy(byClearText, byClearText.length - 8, byLast8Byte, 0, byLast8Byte.length);
        cipher.setIv(iv);
        cipher.setKey(key2);
        byte[] byLast8ByteDecrypt = cipher.decrypt(byLast8Byte);
        cipher.setIv(iv);
        cipher.setKey(key3);
        byte[] byLast8ByteEncrypt = cipher.encrypt(byLast8ByteDecrypt);
        return byLast8ByteEncrypt;
    }

    private static byte[] generateMACSessionKey(byte[] byDoubleLengthKey, byte[] byRandom) throws Exception {
        byte[] byRandomLeft = new byte[byRandom.length];
        byte[] byRandomRight = new byte[byRandom.length];
        System.arraycopy(byRandom, 0, byRandomLeft, 0, byRandom.length);
        System.arraycopy(byRandom, 0, byRandomRight, 0, byRandom.length);
        byRandomLeft[2] = -16;
        byRandomRight[2] = 15;
        byte[] byMACKeyLeft = DESCrypto.crypto(true, byDoubleLengthKey, byRandomLeft);
        byte[] byMACKeyRight = DESCrypto.crypto(true, byDoubleLengthKey, byRandomRight);
        DESCrypto.setOddParity(byMACKeyLeft);
        DESCrypto.setOddParity(byMACKeyRight);
        byte[] byMACSessionKey = new byte[16];
        System.arraycopy(byMACKeyLeft, 0, byMACSessionKey, 0, 8);
        System.arraycopy(byMACKeyRight, 0, byMACSessionKey, 8, 8);
        return byMACSessionKey;
    }

    private static byte[] generateEncryptionSessionKey(byte[] byDoubleLengthKey, byte[] byRandom) throws Exception {
        byte[] byKeyLeft = DESCrypto.crypto(true, byDoubleLengthKey, byRandom);
        DESCrypto.setOddParity(byKeyLeft);
        byte[] byKeyRight = DESCrypto.xor(byRandom, (byte)-1);
        byKeyRight = DESCrypto.crypto(true, byDoubleLengthKey, byKeyRight);
        DESCrypto.setOddParity(byKeyRight);
        byte[] bySessionKey = new byte[16];
        System.arraycopy(byKeyLeft, 0, bySessionKey, 0, 8);
        System.arraycopy(byKeyRight, 0, bySessionKey, 8, 8);
        return bySessionKey;
    }

    public static synchronized byte[] generateMAC(byte[] byDoubleLengthKey, byte[] byRandom, byte[] byPayLoad) throws Exception {
        byte[] byMACSessionKey = DESCrypto.generateMACSessionKey(byDoubleLengthKey, byRandom);
        return DESCrypto.retailMAC(byMACSessionKey, byPayLoad);
    }

    public static synchronized boolean verifyMAC1(byte[] byMAC, byte[] byDoubleLengthKey, byte[] byRandom, byte[] byPayLoad) throws Exception {
        byte[] byGeneratedMAC = DESCrypto.generateMAC(byDoubleLengthKey, byRandom, byPayLoad);
        for (int i = 0; i < byMAC.length; ++i) {
            if (byGeneratedMAC[i] == byMAC[i]) continue;
            return false;
        }
        return true;
    }

    public synchronized byte[] encrypt(byte[] byKey, byte[] byPayLoad) throws Exception {
        return DESCrypto.crypto(true, byKey, byPayLoad);
    }

    public static synchronized byte[] encrypt(byte[] byDoubleLengthKey, byte[] byRandom, byte[] byPayLoad) throws Exception {
        byte[] bySessionKey = DESCrypto.generateEncryptionSessionKey(byDoubleLengthKey, byRandom);
        return DESCrypto.crypto(true, bySessionKey, byPayLoad);
    }

    public synchronized byte[] decrypt(byte[] byKey, byte[] byPayLoad) throws Exception {
        return DESCrypto.crypto(false, byKey, byPayLoad);
    }

    public static synchronized byte[] decrypt(byte[] byDoubleLengthKey, byte[] byRandom, byte[] byPayLoad) throws Exception {
        byte[] bySessionKey = DESCrypto.generateEncryptionSessionKey(byDoubleLengthKey, byRandom);
        return DESCrypto.crypto(false, bySessionKey, byPayLoad);
    }
}

