/*
 * Decompiled with CFR 0.152.
 */
package com.ftindia.internet;

import com.ftindia.internet.AppConstants;
import com.ftindia.internet.Base64;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class Utilities {
    private static Base64 base64 = new Base64();

    public static void WriteLog(String strpMessage) {
        System.out.println(strpMessage);
    }

    public static String[] Split(String strSource, String strDlmter) {
        try {
            Vector<String> vTokens = new Vector<String>();
            StringTokenizer tokenizer = new StringTokenizer(strSource);
            while (tokenizer.hasMoreElements()) {
                String o = tokenizer.nextToken(strDlmter);
                vTokens.addElement(o);
            }
            int iTotal = vTokens.size();
            String[] strOutput = new String[iTotal];
            Enumeration enumtokenlist = vTokens.elements();
            int i = 0;
            while (enumtokenlist.hasMoreElements()) {
                strOutput[i] = (String)enumtokenlist.nextElement();
                ++i;
            }
            return strOutput;
        }
        catch (Exception e) {
            Utilities.WriteLog("Utilities Split " + e.toString());
            return null;
        }
    }

    public static String FindValue(String[] strSource, String strName) {
        int iLength = strSource.length;
        try {
            for (int i = 0; i < iLength; ++i) {
                String[] strData = Utilities.Split(strSource[i], "=");
                if (strData.length != 2 || !strData[0].equals(strName)) continue;
                return strData[1];
            }
        }
        catch (Exception e) {
            Utilities.WriteLog("Utilities-FindValue " + e.toString());
            return "";
        }
        return "";
    }

    public static String FindValue(String strSource, String strFindValue) {
        try {
            if (!strSource.equals("")) {
                String[] arrData = Utilities.Split(strSource, "|");
                return Utilities.FindValue(arrData, strFindValue);
            }
        }
        catch (Exception e) {
            Utilities.WriteLog("Utilities-FindValue " + e.toString());
        }
        return "";
    }

    public static String removeHTTPHeader(String strpSource) {
        try {
            int iStartIndex = -1;
            String strOutput = "";
            strOutput = "";
            iStartIndex = strpSource.indexOf("HTTP/1.1");
            strOutput = iStartIndex >= 0 ? strpSource.substring(0, iStartIndex) : strpSource;
            return strOutput.trim();
        }
        catch (Exception e) {
            Utilities.WriteLog("Utilities removeHTTPHeader   " + e.toString());
            return strpSource;
        }
    }

    public static byte[] doCompression(String outputData) {
        int iLength = outputData.length();
        if (iLength <= 100) {
            iLength = 150;
        }
        byte[] baCompress = new byte[iLength];
        Deflater compresser = new Deflater();
        compresser.setInput(outputData.getBytes());
        compresser.finish();
        int compresslength = compresser.deflate(baCompress);
        byte[] baOutput = new byte[compresslength];
        System.arraycopy(baCompress, 0, baOutput, 0, compresslength);
        return baOutput;
    }

    public static String doDeCompression(byte[] aMessage) {
        try {
            Inflater decompresser = new Inflater();
            decompresser.setInput(aMessage);
            byte[] baDecompress = new byte[aMessage.length * 10];
            int idecompresslength = decompresser.inflate(baDecompress);
            byte[] baOutput = new byte[idecompresslength];
            System.arraycopy(baDecompress, 0, baOutput, 0, idecompresslength);
            String strOutput = new String(baOutput);
            int iEndIndex = strOutput.indexOf(AppConstants.strChar0);
            if (iEndIndex != -1) {
                strOutput = strOutput.substring(0, iEndIndex);
            }
            return strOutput;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String FormatLength(int iLength) {
        String strOutput = "00000";
        String strLength = Integer.toString(iLength);
        int iLengthLength = strLength.length();
        strOutput = iLengthLength == 5 ? strLength : (iLengthLength > 5 ? strLength.substring(0, 5) : strOutput.substring(0, 5 - iLengthLength) + strLength);
        return strOutput;
    }

    public static boolean isInteger(String strSource) {
        try {
            Integer i = Integer.valueOf(strSource);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String GetProxyCredentials(String strProxyCredentials) {
        String strEncodedResult = "";
        try {
            strEncodedResult = base64.encode(strProxyCredentials.getBytes());
        }
        catch (Exception e) {
            Utilities.WriteLog("Utilities-GetProxyCredentials " + e.toString());
        }
        return strEncodedResult;
    }

    public static byte[] AddHTTPHeader(byte[] bSendData, String strIPAddress, String strStartOfMessage) {
        try {
            String strHeaderData = "";
            String strTailData = "";
            byte[] bOutput = null;
            strHeaderData = "Get http://" + strIPAddress + "/";
            strHeaderData = strHeaderData + strStartOfMessage;
            strTailData = strTailData + " HTTP/1.1" + "\r\n";
            strTailData = strTailData + "Accept: /*" + "\r\n";
            strTailData = strTailData + "Accept-Language: en-us" + "\r\n";
            strTailData = strTailData + "Accept-Encoding: gzip, deflate" + "\r\n";
            strTailData = strTailData + "User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.0.3705)" + "\r\n";
            if (AppConstants.Proxy.bProxyServer && !AppConstants.Proxy.strProxyCredentials.equals("")) {
                strTailData = strTailData + "Proxy-Authorization:Basic " + AppConstants.Proxy.strProxyCredentials + "\r\n";
            }
            strTailData = strTailData + "Host: " + strIPAddress + "\r\n";
            strTailData = strTailData + "Connection: Keep-Alive" + "\r\n" + "\r\n";
            byte[] bHeaderData = strHeaderData.getBytes();
            int iHeaderLength = bHeaderData.length;
            byte[] bTailData = strTailData.getBytes();
            int iTailLength = bTailData.length;
            bOutput = new byte[iHeaderLength + bSendData.length + iTailLength];
            System.arraycopy(bHeaderData, 0, bOutput, 0, iHeaderLength);
            System.arraycopy(bSendData, 0, bOutput, iHeaderLength, bSendData.length);
            System.arraycopy(bTailData, 0, bOutput, iHeaderLength + bSendData.length, iTailLength);
            return bOutput;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] HandleFragmentation(byte[] btpReq) {
        try {
            byte[] btReq = null;
            int iReqLength = btpReq.length;
            int iRem = iReqLength % 8;
            int iBlankCnt = 0;
            if (iRem == 0) {
                btReq = btpReq;
                return btReq;
            }
            do {
                ++iBlankCnt;
            } while (++iReqLength % 8 != 0);
            String strBlank = "";
            for (int i = 0; i < iBlankCnt; ++i) {
                strBlank = strBlank + " ";
            }
            btReq = new byte[btpReq.length + iBlankCnt];
            System.arraycopy(btpReq, 0, btReq, 0, btpReq.length);
            System.arraycopy(strBlank.getBytes(), 0, btReq, btpReq.length, strBlank.length());
            return btReq;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

