/*
 * Decompiled with CFR 0.152.
 */
package com.ftindia.internet;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReadRegistry {
    private final Key HKEY_CURRENT_USER = new Key(-2147483647, "HKEY_CURRENT_USER");
    private static final int KEY_ALL_ACCESS = 983103;
    private static final int ERROR_CODE = 1;
    private static final int ERROR_SUCCESS = 0;
    private static final int NATIVE_HANDLE = 0;
    private static final String NULL_STRING = new String(new char[]{'\u0000'});
    private static final String DWORD_KEY = "dword:";
    private static int WAIT_FOR_FILE = 250;
    private Method openKey = null;
    private Method closeKey = null;
    public Key ReadKey = null;

    public ReadRegistry() throws Exception {
        this.checkOS();
        this.initMethods();
        this.ReadKey = this.openKey(this.HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings");
    }

    private void checkOS() throws Exception {
        String str = System.getProperty("os.name");
        if (str == null || str.toLowerCase().indexOf("windows") == -1) {
            throw new Exception("Operating system: " + str + " is not supported!");
        }
    }

    private void initMethods() throws Exception {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.util.prefs.WindowsPreferences");
            Method[] ms = clazz.getDeclaredMethods();
            if (ms == null) {
                throw new Exception("Cannot access java.util.prefs.WindowsPreferences class!");
            }
            for (int x = 0; x != ms.length; ++x) {
                if (ms[x] == null) continue;
                if (ms[x].getName().equals("WindowsRegOpenKey")) {
                    this.openKey = ms[x];
                    this.openKey.setAccessible(true);
                    continue;
                }
                if (!ms[x].getName().equals("WindowsRegCloseKey")) continue;
                this.closeKey = ms[x];
                this.closeKey.setAccessible(true);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new Exception(ex.getMessage());
        }
    }

    private Key openKey(Key key, String subkey) throws Exception {
        return this.openKey(key, subkey, 983103);
    }

    private Key openKey(Key key, String subkey, int security_mask) throws Exception {
        int tmpKey = this._openKey(key.getKey(), subkey, security_mask);
        if (tmpKey == -1) {
            return null;
        }
        return new Key(key, tmpKey, subkey);
    }

    private int _openKey(int key, String subkey, int security_mask) throws Exception {
        try {
            int[] result = (int[])this.openKey.invoke(null, new Integer(key), this.getString(subkey), new Integer(security_mask));
            if (result == null || result[1] != 0) {
                return -1;
            }
            return result[0];
        }
        catch (InvocationTargetException ex1) {
            throw new Exception(ex1.getMessage());
        }
        catch (IllegalArgumentException ex1) {
            throw new Exception(ex1.getMessage());
        }
        catch (IllegalAccessException ex1) {
            throw new Exception(ex1.getMessage());
        }
    }

    private byte[] getString(String str) {
        if (str == null) {
            str = "";
        }
        str = str + "\u0000";
        return str.getBytes();
    }

    public String readDword(Key key, String valueName) throws Exception {
        String ret = this.extractAnyValue(key.getPath(), valueName);
        if (ret != null && ret.startsWith(DWORD_KEY)) {
            return ret.substring(6);
        }
        return null;
    }

    public String extractAnyValue(String path, String valueName) throws Exception {
        StringBuffer strRet = new StringBuffer();
        try {
            File f = File.createTempFile("regorexp", ".jta");
            Runtime.getRuntime().exec("regedit /e " + f.getAbsolutePath() + " \"" + path + "\"").waitFor();
            ReadRegistry._waitForFile(f);
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            String line = "";
            boolean lineFound = false;
            boolean keyFound = false;
            while ((line = br.readLine()) != null) {
                if ((line = line.replaceAll(NULL_STRING, "")).length() <= 0 || !keyFound && (!line.startsWith("[") || !line.endsWith("]"))) continue;
                if (line.startsWith("[") && line.endsWith("]")) {
                    if (keyFound) break;
                    if (!line.equals("[" + path + "]")) continue;
                    keyFound = true;
                    continue;
                }
                if (!keyFound || !lineFound && (!line.startsWith("\"" + valueName) || line.indexOf("=") == -1)) continue;
                if (lineFound) {
                    if (line.length() <= 0) continue;
                    if (line.indexOf("=") != -1) break;
                    strRet.append(line.trim().replaceAll("\\\\", ""));
                    if (line.endsWith("\\")) continue;
                    break;
                }
                line = line.substring(line.indexOf("=") + 1);
                strRet.append(line.replaceAll("\\\\", ""));
                lineFound = true;
                if (line.indexOf("\\") != -1) continue;
            }
            br.close();
            if (!f.delete()) {
                f.deleteOnExit();
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getLocalizedMessage());
            throw new Exception(ex.getLocalizedMessage());
        }
        return strRet.length() == 0 ? null : strRet.toString();
    }

    private static void _waitForFile(File file) {
        try {
            long size = file.length();
            Thread.currentThread();
            Thread.sleep(WAIT_FOR_FILE);
            if (size != file.length()) {
                ReadRegistry._waitForFile(file);
            }
        }
        catch (Exception ex) {
            System.err.println("ERROR WAITING FOR FILE: " + file);
        }
    }

    public int closeKey(Key key) throws Exception {
        return this._closeKey(key.getKey());
    }

    private int _closeKey(int key) throws Exception {
        try {
            Integer ret = (Integer)this.closeKey.invoke(null, new Integer(key));
            if (ret != null) {
                return ret;
            }
            return -1;
        }
        catch (InvocationTargetException ex) {
            throw new Exception(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new Exception(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new Exception(ex.getMessage());
        }
    }

    public final class Key {
        private String path;
        private int key;

        public Key() {
        }

        public Key(int key, String path) {
            this.key = key;
            this.path = path;
        }

        protected Key(Key parentKey, int key, String subPath) {
            this.key = key;
            this.path = parentKey.getPath() + "\\" + subPath;
        }

        public int getKey() {
            return this.key;
        }

        public String getPath() {
            return this.path;
        }
    }
}

