/*
 * Decompiled with CFR 0.152.
 */
package com.ftindia.internet;

import com.ftindia.internet.AppConstants;
import com.ftindia.internet.AppletMethods;

class ConnectionThread
extends Thread {
    private AppletMethods appletmethods = null;
    private int iInteractiveConnectionAttempts = 0;
    private int iCounter = 0;

    public ConnectionThread(AppletMethods pappletmethods) {
        this.appletmethods = pappletmethods;
    }

    public void run() {
        this.iCounter = 0;
        try {
            this.iInteractiveConnectionAttempts = 0;
            while (true) {
                if (this.appletmethods.bConnectToInteractiveServer) {
                    if (this.iInteractiveConnectionAttempts > AppConstants.iSocketReconnectCount) {
                        this.appletmethods.CallJSFunction("handleMaximumReConnection", new String[]{"1"});
                        break;
                    }
                    ++this.iCounter;
                    if (this.appletmethods.ConnectToGatewayServer() != AppConstants.ErrorCodes.VAL_SUCCESS) {
                        this.appletmethods.CallJSFunction("handleConnectionFailure", new String[]{"1"});
                        ++this.iInteractiveConnectionAttempts;
                    } else {
                        this.iInteractiveConnectionAttempts = 0;
                        this.appletmethods.bConnectToInteractiveServer = false;
                        this.appletmethods.CallJSFunction("handleConnect", new String[]{"true"});
                        this.appletmethods.StartReceive();
                    }
                }
                if (AppConstants.bAppletInitiated && this.iCounter != 0) {
                    Thread.sleep(AppConstants.lSocketReconnectTime);
                    continue;
                }
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

