/*
 * Decompiled with CFR 0.152.
 */
package com.ftindia.internet;

import com.ftindia.internet.AppConstants;
import com.ftindia.internet.AppletMethods;
import com.ftindia.internet.Utilities;
import crypto.DESCrypto;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class Communication
extends Thread {
    private Socket socket;
    private InputStream inputstream;
    private OutputStream outputstream;
    private DataInputStream oDataInputStream;
    private String strOCIPAddress = "";
    private int iOCPort = 0;
    private String strProxyIPAddress = "";
    private int iProxyPort = 0;
    private String strEncryptKey = "1234567801234567";
    private String strNewEncryptKey = "";
    public boolean bLoggedIn = false;
    private String strOldData = "";
    private byte[] baOldData;
    private DESCrypto desCrypto = new DESCrypto();
    private AppletMethods appletmethods = null;
    private String strJSAuthenticate = "";
    public boolean bConnected = false;
    public boolean bStarted = false;

    public Communication() {
    }

    public Communication(AppletMethods pappletmethods, String strAuthenticateCall) {
        this.appletmethods = pappletmethods;
        this.strJSAuthenticate = strAuthenticateCall;
    }

    public void SetODinConnectDetails(String strIPAddress, int iPort) {
        this.strOCIPAddress = strIPAddress;
        this.iOCPort = iPort;
    }

    public void SetProxyDetails(String strIPAddress, int iPort) {
        this.strProxyIPAddress = strIPAddress;
        this.iProxyPort = iPort;
    }

    public int ConnectToGatewayServer() {
        try {
            this.ClearData();
            this.socket = AppConstants.Proxy.bProxyServer ? new Socket(this.strProxyIPAddress, this.iProxyPort) : new Socket(this.strOCIPAddress, this.iOCPort);
            this.outputstream = this.socket.getOutputStream();
            this.inputstream = this.socket.getInputStream();
            this.oDataInputStream = new DataInputStream(this.inputstream);
            this.bConnected = true;
            if (AppConstants.Proxy.bProxyServer) {
                this.SendConnect();
            }
            return AppConstants.ErrorCodes.VAL_SUCCESS;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.appletmethods.HandleError("Communication.java", "ConnectToGatewayServer", e.toString());
            return AppConstants.ErrorCodes.VAL_EXCEPTION;
        }
    }

    public void ClearData() {
        this.socket = null;
        this.outputstream = null;
        this.inputstream = null;
        this.oDataInputStream = null;
        this.bLoggedIn = false;
        this.bConnected = false;
        this.bStarted = false;
    }

    public String GetConnectHeader() {
        try {
            String strMsg = "";
            strMsg = "CONNECT " + this.strOCIPAddress + ":" + this.iOCPort + " HTTP/1.1";
            strMsg = strMsg + "\r\n";
            strMsg = strMsg + "Accept: */*" + "\r\n";
            strMsg = strMsg + "Accept-Language: en-us" + "\r\n";
            strMsg = strMsg + "Accept-Encoding: gzip, deflate" + "\r\n";
            strMsg = strMsg + "User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.0.3705)" + "\r\n";
            if (!AppConstants.Proxy.strProxyCredentials.equals("")) {
                strMsg = strMsg + "Proxy-Authorization: Basic " + AppConstants.Proxy.strProxyCredentials + "\r\n";
            }
            strMsg = strMsg + "Host: " + this.strOCIPAddress + ":" + this.iOCPort + "\r\n";
            strMsg = strMsg + "Connection: Keep-Alive" + "\r\n" + "\r\n";
            return strMsg;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.appletmethods.HandleError("Communication.java", "GetConnectHeader", e.toString());
            return "";
        }
    }

    public void SendConnect() {
        try {
            String strConnect = "";
            strConnect = this.GetConnectHeader();
            this.outputstream.write(strConnect.getBytes(), 0, strConnect.length());
            this.outputstream.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.appletmethods.HandleError("Communication.java", "SendConnect", e.toString());
        }
    }

    public void Disconnect() {
        try {
            this.inputstream.close();
            this.outputstream.close();
            this.oDataInputStream.close();
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean Request(String strRequest) {
        try {
            byte[] baCompressedData;
            byte[] baRequest = null;
            if (AppConstants.bCompression && !AppConstants.bEncryption) {
                baCompressedData = Utilities.doCompression(strRequest);
                byte[] baLength = Utilities.FormatLength(baCompressedData.length).getBytes();
                byte[] baData = new byte[5 + baCompressedData.length];
                System.arraycopy(baLength, 0, baData, 0, baLength.length);
                System.arraycopy(baCompressedData, 0, baData, 5, baCompressedData.length);
                baRequest = Utilities.AddHTTPHeader(baData, this.strOCIPAddress, AppConstants.strChar5);
            } else if (AppConstants.bEncryption && !AppConstants.bCompression) {
                byte[] baDataFinal = Utilities.HandleFragmentation(strRequest.getBytes());
                byte[] baLength = Utilities.FormatLength(baDataFinal.length).getBytes();
                byte[] baEncryptData = null;
                byte[] baData = new byte[5 + baDataFinal.length];
                System.arraycopy(baLength, 0, baData, 0, baLength.length);
                if (!this.bLoggedIn) {
                    baEncryptData = this.desCrypto.encrypt(this.strEncryptKey.getBytes(), baDataFinal);
                    System.arraycopy(baEncryptData, 0, baData, baLength.length, baEncryptData.length);
                    baRequest = Utilities.AddHTTPHeader(baData, this.strOCIPAddress, AppConstants.strChar3);
                } else {
                    baEncryptData = this.desCrypto.encrypt(this.strNewEncryptKey.getBytes(), baDataFinal);
                    System.arraycopy(baEncryptData, 0, baData, baLength.length, baEncryptData.length);
                    baRequest = Utilities.AddHTTPHeader(baData, this.strOCIPAddress, AppConstants.strChar4);
                }
            } else if (AppConstants.bCompression && AppConstants.bEncryption) {
                baCompressedData = Utilities.doCompression(strRequest);
                baCompressedData = Utilities.HandleFragmentation(baCompressedData);
                byte[] baLength = Utilities.FormatLength(baCompressedData.length).getBytes();
                byte[] baEncryptData = null;
                byte[] baData = new byte[5 + baCompressedData.length];
                System.arraycopy(baLength, 0, baData, 0, baLength.length);
                if (!this.bLoggedIn) {
                    baEncryptData = this.desCrypto.encrypt(this.strEncryptKey.getBytes(), baCompressedData);
                    System.arraycopy(baEncryptData, 0, baData, baLength.length, baEncryptData.length);
                    baRequest = Utilities.AddHTTPHeader(baData, this.strOCIPAddress, AppConstants.strChar6);
                } else {
                    baEncryptData = this.desCrypto.encrypt(this.strNewEncryptKey.getBytes(), baCompressedData);
                    System.arraycopy(baEncryptData, 0, baData, baLength.length, baEncryptData.length);
                    baRequest = Utilities.AddHTTPHeader(baData, this.strOCIPAddress, AppConstants.strChar7);
                }
            } else {
                baRequest = Utilities.AddHTTPHeader(strRequest.getBytes(), this.strOCIPAddress, AppConstants.strChar2);
            }
            if (baRequest != null) {
                try {
                    this.outputstream.write(baRequest, 0, baRequest.length);
                    this.outputstream.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.bConnected = false;
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.appletmethods.HandleError("Communication.java", "Request", e.toString());
            return false;
        }
    }

    public void run() {
        int iAvailableBytes = 0;
        this.bStarted = true;
        boolean bProxyResponse = false;
        while (this.bConnected) {
            try {
                if (!this.bConnected) break;
                if (this.bConnected) {
                    iAvailableBytes = 0;
                    if (this.oDataInputStream != null) {
                        iAvailableBytes = this.oDataInputStream.available();
                    }
                    if (iAvailableBytes > 0) {
                        byte[] baReadData = new byte[iAvailableBytes];
                        this.oDataInputStream.readFully(baReadData, 0, iAvailableBytes);
                        if (!bProxyResponse && AppConstants.Proxy.bProxyServer) {
                            bProxyResponse = true;
                            String sProxyResponse = new String(baReadData);
                            if (!sProxyResponse.startsWith("HTTP/1.0 200") && !sProxyResponse.startsWith("HTTP/1.1 200")) {
                                this.bConnected = false;
                                if (this.strJSAuthenticate.equals("handleAuthentication")) {
                                    this.appletmethods.CallJSFunction("handleConnectionFailure", new String[]{"3"});
                                } else {
                                    this.appletmethods.CallJSFunction("handleConnectionFailure", new String[]{"4"});
                                }
                            }
                        } else if (AppConstants.bEncryption) {
                            this.HandleEncryptData(baReadData);
                        } else if (AppConstants.bCompression) {
                            this.HandleCompressedData(baReadData);
                        } else {
                            this.HandleReadData(baReadData);
                        }
                    }
                }
                Thread.sleep(100L);
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace();
                System.out.println("Communication OutOfMemoryError " + e.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.appletmethods.HandleError("Communication.java", "run", e.toString());
                this.bConnected = false;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void HandleEncryptData(byte[] baData) {
        try {
            byte[] baProcessData = null;
            if (this.baOldData != null && this.baOldData.length > 0) {
                baProcessData = this.HandleDataFragmentation(baData);
            }
            if (baProcessData == null) {
                baProcessData = new byte[baData.length];
                System.arraycopy(baData, 0, baProcessData, 0, baData.length);
            }
            while (baProcessData.length > 5) {
                String strEncryptData = new String(baProcessData);
                int iIndex = -1;
                iIndex = AppConstants.bCompression ? (this.bLoggedIn ? strEncryptData.indexOf(AppConstants.strChar7) : strEncryptData.indexOf(AppConstants.strChar6)) : (this.bLoggedIn ? strEncryptData.indexOf(AppConstants.strChar4) : strEncryptData.indexOf(AppConstants.strChar3));
                if (iIndex != -1 && baProcessData.length > iIndex + 6) {
                    int iEncryptLength = Integer.parseInt(strEncryptData.substring(iIndex + 1, iIndex + 6), 10);
                    byte[] baEncryptData = new byte[baProcessData.length - iIndex - 6];
                    System.arraycopy(baProcessData, iIndex + 6, baEncryptData, 0, baProcessData.length - iIndex - 6);
                    int iReadLength = baEncryptData.length;
                    if (iReadLength >= iEncryptLength) {
                        byte[] baTempData = new byte[iEncryptLength];
                        System.arraycopy(baEncryptData, 0, baTempData, 0, iEncryptLength);
                        byte[] baDecryptData = this.bLoggedIn ? this.desCrypto.decrypt(this.strNewEncryptKey.getBytes(), baTempData) : this.desCrypto.decrypt(this.strEncryptKey.getBytes(), baTempData);
                        String strProcessData = "";
                        if (AppConstants.bCompression) {
                            strProcessData = Utilities.doDeCompression(baDecryptData);
                        } else {
                            strProcessData = new String(baDecryptData);
                            int iEndIndex = strProcessData.indexOf(AppConstants.strChar0);
                            if (iEndIndex != -1) {
                                strProcessData = strProcessData.substring(0, iEndIndex);
                            }
                        }
                        int iMessageCount = 0;
                        String[] arrData = Utilities.Split(strProcessData, AppConstants.strChar2);
                        iMessageCount = arrData.length;
                        for (int iIterator = 0; iIterator < iMessageCount; ++iIterator) {
                            if (arrData[iIterator].equals("")) continue;
                            if (!this.bLoggedIn) {
                                this.ProcessLogonResponse(arrData[iIterator]);
                            }
                            this.appletmethods.HandleIncomingMessage(arrData[iIterator]);
                        }
                        if (iReadLength == iEncryptLength) {
                            return;
                        }
                        baProcessData = null;
                        baProcessData = new byte[iReadLength - iEncryptLength];
                        System.arraycopy(baEncryptData, iEncryptLength, baProcessData, 0, iReadLength - iEncryptLength);
                        baEncryptData = null;
                        baDecryptData = null;
                        baTempData = null;
                        continue;
                    }
                    this.baOldData = null;
                    this.baOldData = new byte[baProcessData.length];
                    System.arraycopy(baProcessData, 0, this.baOldData, 0, baProcessData.length);
                    return;
                }
                this.baOldData = null;
                this.baOldData = new byte[baProcessData.length];
                System.arraycopy(baProcessData, 0, this.baOldData, 0, baProcessData.length);
                return;
            }
            this.baOldData = null;
            this.baOldData = new byte[baProcessData.length];
            System.arraycopy(baProcessData, 0, this.baOldData, 0, baProcessData.length);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.appletmethods.HandleError("Communication.java", "HandleEncryptData", e.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void HandleCompressedData(byte[] baData) {
        try {
            byte[] baProcessData = null;
            if (this.baOldData != null && this.baOldData.length > 0) {
                baProcessData = this.HandleDataFragmentation(baData);
            }
            if (baProcessData == null) {
                baProcessData = new byte[baData.length];
                System.arraycopy(baData, 0, baProcessData, 0, baData.length);
            }
            while (baProcessData.length > 5) {
                String strCompressData = new String(baProcessData);
                int iIndex = strCompressData.indexOf(AppConstants.strChar5);
                if (iIndex != -1 && baProcessData.length > iIndex + 6) {
                    int iCompressLength = Integer.parseInt(strCompressData.substring(iIndex + 1, iIndex + 6), 10);
                    byte[] baCompressData = new byte[baProcessData.length - iIndex - 6];
                    System.arraycopy(baProcessData, iIndex + 6, baCompressData, 0, baProcessData.length - iIndex - 6);
                    int iReadLength = baCompressData.length;
                    if (iReadLength >= iCompressLength) {
                        byte[] baUnCompress = new byte[iCompressLength];
                        System.arraycopy(baCompressData, 0, baUnCompress, 0, iCompressLength);
                        String strProcessData = "";
                        strProcessData = Utilities.doDeCompression(baUnCompress);
                        int iMessageCount = 0;
                        String[] arrData = Utilities.Split(strProcessData, AppConstants.strChar2);
                        iMessageCount = arrData.length;
                        for (int iIterator = 0; iIterator < iMessageCount; ++iIterator) {
                            if (arrData[iIterator].equals("")) continue;
                            if (!this.bLoggedIn) {
                                this.ProcessLogonResponse(arrData[iIterator]);
                            }
                            this.appletmethods.HandleIncomingMessage(arrData[iIterator]);
                        }
                        if (iReadLength == iCompressLength) {
                            return;
                        }
                        baProcessData = null;
                        baProcessData = new byte[iReadLength - iCompressLength];
                        System.arraycopy(baCompressData, iCompressLength, baProcessData, 0, iReadLength - iCompressLength);
                        baCompressData = null;
                        baUnCompress = null;
                        continue;
                    }
                    this.baOldData = null;
                    this.baOldData = new byte[baProcessData.length];
                    System.arraycopy(baProcessData, 0, this.baOldData, 0, baProcessData.length);
                    return;
                }
                this.baOldData = null;
                this.baOldData = new byte[baProcessData.length];
                System.arraycopy(baProcessData, 0, this.baOldData, 0, baProcessData.length);
                return;
            }
            this.baOldData = null;
            this.baOldData = new byte[baProcessData.length];
            System.arraycopy(baProcessData, 0, this.baOldData, 0, baProcessData.length);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.appletmethods.HandleError("Communication.java", "HandleCompressedData", e.toString());
        }
    }

    private void HandleReadData(byte[] baData) {
        try {
            int iEndIndex;
            int iHTTPIndex;
            String strProcessData = "";
            String strReadData = "";
            strReadData = new String(baData);
            if (!(this.strOldData.equals("") || (iHTTPIndex = strReadData.indexOf("HTTP")) <= 0 && iHTTPIndex != -1)) {
                strProcessData = strProcessData.concat(this.strOldData);
                strProcessData = strProcessData.concat(strReadData);
                this.strOldData = "";
            }
            if (strProcessData.equals("")) {
                strProcessData = strProcessData.concat(strReadData);
            }
            if ((iEndIndex = strProcessData.indexOf(AppConstants.strChar0)) != -1) {
                strProcessData = strProcessData.substring(0, iEndIndex);
            }
            String[] arrData = null;
            int iMessageCount = 0;
            arrData = Utilities.Split(strProcessData, AppConstants.strChar2);
            iMessageCount = arrData.length;
            for (int i = 0; i < iMessageCount - 1; ++i) {
                if (arrData[i].equals("")) continue;
                if (!this.bLoggedIn) {
                    this.ProcessLogonResponse(arrData[i]);
                }
                this.appletmethods.HandleIncomingMessage(arrData[i]);
            }
            String strMessageLength = "";
            int iMessageLength = 0;
            strMessageLength = Utilities.FindValue(arrData[iMessageCount - 1], Integer.toString(65, 10));
            if (strMessageLength.equals("")) {
                this.strOldData = arrData[iMessageCount - 1];
            } else {
                iMessageLength = Integer.parseInt(strMessageLength, 10);
                if (arrData[iMessageCount - 1].length() >= iMessageLength) {
                    if (!this.bLoggedIn) {
                        this.ProcessLogonResponse(arrData[iMessageCount - 1]);
                    }
                    this.appletmethods.HandleIncomingMessage(arrData[iMessageCount - 1]);
                } else {
                    this.strOldData = arrData[iMessageCount - 1];
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.appletmethods.HandleError("Communication.java", "HandleReadData", e.toString());
        }
    }

    private byte[] HandleDataFragmentation(byte[] baLastData) {
        try {
            String strData = new String(baLastData);
            byte[] baFragmentData = null;
            int iHTTPIndex = strData.indexOf("HTTP");
            if (iHTTPIndex > 0 || iHTTPIndex == -1) {
                baFragmentData = new byte[this.baOldData.length + baLastData.length];
                System.arraycopy(this.baOldData, 0, baFragmentData, 0, this.baOldData.length);
                System.arraycopy(baLastData, 0, baFragmentData, this.baOldData.length, baLastData.length);
                this.baOldData = null;
                return baFragmentData;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.appletmethods.HandleError("Communication.java", "HandleDataFragmentation", e.toString());
        }
        return null;
    }

    private void ProcessLogonResponse(String strResponseString) {
        try {
            String strDaysToExpire = "";
            String strAccToExpire = "";
            String strLogonMessage = "";
            int iLogonStatus = -1;
            String[] strResponse = Utilities.Split(strResponseString, "|");
            strDaysToExpire = Utilities.FindValue(strResponse, Integer.toString(97)).trim();
            strAccToExpire = Utilities.FindValue(strResponse, Integer.toString(997)).trim();
            strLogonMessage = Utilities.FindValue(strResponse, Integer.toString(19)).trim();
            String strLogonStatus = Utilities.FindValue(strResponse, Integer.toString(70));
            if (AppConstants.bEncryption) {
                this.strNewEncryptKey = Utilities.FindValue(strResponse, Integer.toString(394)).trim();
            }
            if (Utilities.isInteger(strLogonStatus)) {
                iLogonStatus = Integer.parseInt(strLogonStatus);
            }
            String strStatus = "";
            if (iLogonStatus == 10000 || iLogonStatus == 10006 || iLogonStatus == 10004 || iLogonStatus == 10019 || iLogonStatus == 10020) {
                if (iLogonStatus == 10000) {
                    strStatus = "Logon success";
                } else if (iLogonStatus == 10006) {
                    strStatus = "New Password Changed Successfully";
                } else if (iLogonStatus == 10004) {
                    strStatus = "Password expires in " + strDaysToExpire + " days";
                } else if (iLogonStatus == 10019) {
                    strStatus = "Password expires in " + strDaysToExpire + " days. " + "Account expires in " + strAccToExpire + " days";
                } else if (iLogonStatus == 10020) {
                    strStatus = "Account expires in " + strAccToExpire + " days";
                }
                this.bLoggedIn = true;
            } else {
                switch (iLogonStatus) {
                    case 10001: {
                        strStatus = "Incorrect Client ID/Password";
                        break;
                    }
                    case 10002: {
                        strStatus = "Incorrect Client ID/Password";
                        break;
                    }
                    case 10003: {
                        strStatus = "Account is disabled. Contact Admin";
                        break;
                    }
                    case 10004: {
                        strStatus = "Password expires in ";
                        break;
                    }
                    case 10005: {
                        strStatus = "Invalid password. Account is disabled. Contact Admin";
                        break;
                    }
                    case 10006: {
                        strStatus = "New Password Changed Successfully";
                        break;
                    }
                    case 10007: {
                        strStatus = "Your password expired, Please change the password";
                        break;
                    }
                    case 10008: {
                        strStatus = "User Already Logged In";
                        break;
                    }
                    case 10009: {
                        strStatus = "Password validation Failed";
                        break;
                    }
                    case 10012: {
                        strStatus = "Invalid Mobile Number";
                        break;
                    }
                    case 10011: {
                        strStatus = "Invalid Connection Type";
                        break;
                    }
                    case 10010: {
                        strStatus = strLogonMessage;
                        break;
                    }
                    case 10013: {
                        strStatus = "New Password cannot be same as previous passwords";
                        break;
                    }
                    case 10015: {
                        strStatus = "Invalid Purge value in Logon Request";
                        break;
                    }
                    case 10016: {
                        strStatus = "User suspended";
                        break;
                    }
                    case 10017: {
                        strStatus = "User deleted";
                        break;
                    }
                    case 10018: {
                        strStatus = "Account disabled due to lapse of account expiry date";
                        break;
                    }
                    case 10022: {
                        strStatus = "Access Denied";
                        break;
                    }
                    case 10024: {
                        strStatus = " OMS Server is not up.";
                        break;
                    }
                    case 10021: {
                        strStatus = "User already Logged In through Lite Mode";
                        break;
                    }
                    default: {
                        strStatus = "Logon failed" + iLogonStatus + " " + strLogonMessage;
                    }
                }
                this.bLoggedIn = false;
            }
            this.appletmethods.CallJSFunction(this.strJSAuthenticate, new String[]{Boolean.toString(this.bLoggedIn), strLogonStatus, strStatus});
        }
        catch (Exception e) {
            e.printStackTrace();
            this.appletmethods.HandleError("Communication.java", "ProcessLogonResponse", e.toString());
        }
    }
}

