/*
 * Decompiled with CFR 0.152.
 */
package com.ftindia.internet;

public class Base64 {
    protected static final boolean DEBUGGING = false;
    private static final String RELEASEDATE = "2007-05-20";
    private static final String TITLESTRING = "Base64";
    private static final String VERSIONSTRING = "1.9";
    protected static final int IGNORE = -1;
    protected static final int PAD = -2;
    protected static char[] vc;
    protected static int[] cv;
    protected String lineSeparator = System.getProperty("line.separator");
    protected char[] valueToChar;
    protected char spec1 = (char)43;
    protected char spec2 = (char)47;
    protected char spec3 = (char)61;
    protected int[] charToValue;
    protected int lineLength = 72;

    public static void show(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            System.out.print(Integer.toHexString(b[i] & 0xFF) + " ");
        }
        System.out.println();
    }

    public Base64() {
        this.spec1 = (char)43;
        this.spec2 = (char)47;
        this.spec3 = (char)61;
        this.initTables();
    }

    public byte[] decode(String s) {
        byte[] b = new byte[s.length() / 4 * 3];
        int cycle = 0;
        int combined = 0;
        int j = 0;
        int len = s.length();
        int dummies = 0;
        block10: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            int value = c <= '\u00ff' ? this.charToValue[c] : -1;
            switch (value) {
                case -1: {
                    continue block10;
                }
                case -2: {
                    value = 0;
                    ++dummies;
                }
                default: {
                    switch (cycle) {
                        case 0: {
                            combined = value;
                            cycle = 1;
                            continue block10;
                        }
                        case 1: {
                            combined <<= 6;
                            combined |= value;
                            cycle = 2;
                            continue block10;
                        }
                        case 2: {
                            combined <<= 6;
                            combined |= value;
                            cycle = 3;
                            continue block10;
                        }
                        case 3: {
                            combined <<= 6;
                            b[j + 2] = (byte)(combined |= value);
                            b[j + 1] = (byte)(combined >>>= 8);
                            b[j] = (byte)(combined >>>= 8);
                            j += 3;
                            cycle = 0;
                        }
                    }
                }
            }
        }
        if (cycle != 0) {
            throw new ArrayIndexOutOfBoundsException("Input to decode not an even multiple of 4 characters; pad with " + this.spec3);
        }
        if (b.length != (j -= dummies)) {
            byte[] b2 = new byte[j];
            System.arraycopy(b, 0, b2, 0, j);
            b = b2;
        }
        return b;
    }

    public String encode(byte[] b) {
        int lines;
        int outputLength = (b.length + 2) / 3 * 4;
        if (this.lineLength != 0 && (lines = (outputLength + this.lineLength - 1) / this.lineLength - 1) > 0) {
            outputLength += lines * this.lineSeparator.length();
        }
        StringBuffer sb = new StringBuffer(outputLength);
        int linePos = 0;
        int len = b.length / 3 * 3;
        int leftover = b.length - len;
        for (int i = 0; i < len; i += 3) {
            if ((linePos += 4) > this.lineLength && this.lineLength != 0) {
                sb.append(this.lineSeparator);
            }
            int combined = b[i] & 0xFF;
            combined <<= 8;
            combined |= b[i + 1] & 0xFF;
            combined <<= 8;
            int c3 = (combined |= b[i + 2] & 0xFF) & 0x3F;
            int c2 = (combined >>>= 6) & 0x3F;
            int c1 = (combined >>>= 6) & 0x3F;
            int c0 = (combined >>>= 6) & 0x3F;
            sb.append(this.valueToChar[c0]);
            sb.append(this.valueToChar[c1]);
            sb.append(this.valueToChar[c2]);
            sb.append(this.valueToChar[c3]);
        }
        switch (leftover) {
            default: {
                break;
            }
            case 1: {
                if ((linePos += 4) > this.lineLength && this.lineLength != 0) {
                    sb.append(this.lineSeparator);
                }
                sb.append(this.encode(new byte[]{b[len], 0, 0}).substring(0, 2));
                sb.append(this.spec3);
                sb.append(this.spec3);
                break;
            }
            case 2: {
                if ((linePos += 4) > this.lineLength && this.lineLength != 0) {
                    sb.append(this.lineSeparator);
                }
                sb.append(this.encode(new byte[]{b[len], b[len + 1], 0}).substring(0, 3));
                sb.append(this.spec3);
            }
        }
        if (outputLength != sb.length()) {
            System.out.println("oops: minor program flaw: output length mis-estimated");
            System.out.println("estimate:" + outputLength);
            System.out.println("actual:" + sb.length());
        }
        return sb.toString();
    }

    public final void setLineLength(int length) {
        this.lineLength = length / 4 * 4;
    }

    public final void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    private void initTables() {
        if (vc == null) {
            int i;
            vc = new char[64];
            cv = new int[256];
            for (i = 0; i <= 25; ++i) {
                Base64.vc[i] = (char)(65 + i);
            }
            for (i = 0; i <= 25; ++i) {
                Base64.vc[i + 26] = (char)(97 + i);
            }
            for (i = 0; i <= 9; ++i) {
                Base64.vc[i + 52] = (char)(48 + i);
            }
            Base64.vc[62] = this.spec1;
            Base64.vc[63] = this.spec2;
            for (i = 0; i < 256; ++i) {
                Base64.cv[i] = -1;
            }
            for (i = 0; i < 64; ++i) {
                Base64.cv[Base64.vc[i]] = i;
            }
            Base64.cv[this.spec3] = -2;
        }
        this.valueToChar = vc;
        this.charToValue = cv;
    }

    public static void main(String[] args) {
    }
}

