/*
 * Decompiled with CFR 0.152.
 */
package com.ftindia.internet;

import com.ftindia.internet.AppConstants;
import com.ftindia.internet.Communication;
import com.ftindia.internet.ConnectionBCThread;
import com.ftindia.internet.ConnectionThread;
import com.ftindia.internet.KeepAliveThread;
import com.ftindia.internet.Utilities;
import netscape.javascript.JSObject;

public class AppletMethods {
    private KeepAliveThread keepalivethread = null;
    private ConnectionThread connectionthread = null;
    private ConnectionBCThread connectionbcthread = null;
    Communication interactivethread = null;
    Communication broadcastthread = null;
    boolean bConnectToInteractiveServer = false;
    boolean bConnectToBroadCastServer = false;
    private JSObject jso = null;

    public AppletMethods() {
        this.InitializeInteractiveThread();
        this.InitializeBroadCastThread();
        this.StartConnection();
    }

    private void InitializeInteractiveThread() {
        this.interactivethread = null;
        this.interactivethread = new Communication(this, "handleAuthentication");
    }

    private void InitializeBroadCastThread() {
        this.broadcastthread = null;
        this.broadcastthread = new Communication(this, "handleBCAuthentication");
    }

    public void StartKeepAlive() {
        try {
            this.keepalivethread = null;
            if (this.interactivethread.bConnected) {
                this.keepalivethread = new KeepAliveThread(this, AppConstants.lKeepAliveTime);
                this.keepalivethread.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.HandleError("AppletMethods.java", "StartKeepAlive", e.toString());
        }
    }

    public void StartConnection() {
        try {
            this.connectionthread = new ConnectionThread(this);
            this.connectionthread.start();
            this.connectionbcthread = new ConnectionBCThread(this);
            this.connectionbcthread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.HandleError("AppletMethods.java", "StartConnection", e.toString());
        }
    }

    public void SetServerDetails(String strpIPAddress, int ipInteractivePortNo, String strpBCastIPAddr, int ipBroadcastPortNo) {
        try {
            this.interactivethread.ClearData();
            this.interactivethread.SetODinConnectDetails(strpIPAddress, ipInteractivePortNo);
            this.bConnectToInteractiveServer = true;
            if (AppConstants.bMultipleOC) {
                this.broadcastthread.ClearData();
                this.broadcastthread.SetODinConnectDetails(strpBCastIPAddr, ipBroadcastPortNo);
                this.bConnectToBroadCastServer = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.HandleError("AppletMethods.java", "SetServerDetails", e.toString());
        }
    }

    public void SetProxyServerAuthenticationDetails(String strpUserId, String strpPassword) {
        try {
            AppConstants.Proxy.strUserid = strpUserId;
            AppConstants.Proxy.strPassword = strpPassword;
            AppConstants.Proxy.strProxyCredentials = Utilities.GetProxyCredentials(strpUserId + ":" + strpPassword);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.HandleError("AppletMethods.java", "SetProxyServerAuthenticationDetails", e.toString());
        }
    }

    public void SetProxyServerDetails(String strpProxyIPAddress, int ipProxyPortNo) {
        try {
            if (!strpProxyIPAddress.equals("") && ipProxyPortNo != 0) {
                AppConstants.Proxy.strProxyIPAddress = strpProxyIPAddress;
                AppConstants.Proxy.iProxyPort = ipProxyPortNo;
                AppConstants.Proxy.bProxyServer = true;
                this.interactivethread.SetProxyDetails(strpProxyIPAddress, ipProxyPortNo);
                if (AppConstants.bMultipleOC) {
                    this.broadcastthread.SetProxyDetails(strpProxyIPAddress, ipProxyPortNo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.HandleError("AppletMethods.java", "SetProxyServerDetails", e.toString());
        }
    }

    public int ConnectToBCastServer() {
        return this.broadcastthread.ConnectToGatewayServer();
    }

    public int ConnectToGatewayServer() {
        return this.interactivethread.ConnectToGatewayServer();
    }

    public boolean Request(String strpRequest) {
        boolean bSuccess = this.interactivethread.Request(strpRequest);
        if (!bSuccess) {
            this.interactivethread.ClearData();
            this.CallJSFunction("handleDisConnect", new String[]{"false"});
            this.InitializeInteractiveThread();
            if (AppConstants.Proxy.bProxyServer) {
                this.interactivethread.SetProxyDetails(AppConstants.Proxy.strProxyIPAddress, AppConstants.Proxy.iProxyPort);
            }
            this.interactivethread.SetODinConnectDetails(AppConstants.strOCInteractiveIP, AppConstants.iOCInteractivePort);
            this.bConnectToInteractiveServer = true;
        } else {
            ++AppConstants.lRequestCount;
        }
        return bSuccess;
    }

    public boolean RequestBCast(String strpRequest) {
        if (AppConstants.bMultipleOC) {
            boolean bSuccess = this.broadcastthread.Request(strpRequest);
            if (!bSuccess) {
                this.broadcastthread.ClearData();
                this.CallJSFunction("handleBCDisConnect", new String[]{"false"});
                this.InitializeBroadCastThread();
                if (AppConstants.Proxy.bProxyServer) {
                    this.broadcastthread.SetProxyDetails(AppConstants.Proxy.strProxyIPAddress, AppConstants.Proxy.iProxyPort);
                }
                this.broadcastthread.SetODinConnectDetails(AppConstants.strOCBroadCasrIP, AppConstants.iOCBroadCastPort);
                this.bConnectToBroadCastServer = true;
            } else {
                ++AppConstants.lRequestCount;
            }
            return bSuccess;
        }
        return this.Request(strpRequest);
    }

    public int StartReceive() {
        try {
            if (this.interactivethread.bConnected && !this.interactivethread.bStarted) {
                this.interactivethread.start();
            }
            return AppConstants.ErrorCodes.VAL_SUCCESS;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.HandleError("AppletMethods", "StartReceive", e.toString());
            return AppConstants.ErrorCodes.VAL_EXCEPTION;
        }
    }

    public int StartBCastReceive() {
        try {
            if (this.broadcastthread.bConnected && !this.broadcastthread.bStarted) {
                this.broadcastthread.start();
            }
            return AppConstants.ErrorCodes.VAL_SUCCESS;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.HandleError("AppletMethods", "StartBCastReceive", e.toString());
            return AppConstants.ErrorCodes.VAL_EXCEPTION;
        }
    }

    public final synchronized void HandleIncomingMessage(String m) {
        String strToProcess = Utilities.removeHTTPHeader(m);
        if (!strToProcess.equals("")) {
            this.CallJSFunction("handleData", new String[]{strToProcess});
            ++AppConstants.lPacketCount;
        }
    }

    public void CloseSocketConnection() {
        this.interactivethread.Disconnect();
        this.interactivethread.ClearData();
        if (AppConstants.bMultipleOC) {
            this.broadcastthread.Disconnect();
            this.broadcastthread.ClearData();
        }
    }

    public void SetJSObject(JSObject objJS) {
        this.jso = objJS;
    }

    public void CallJSFunction(String strFunction, String[] strParam) {
        if (this.jso != null) {
            try {
                this.jso.call(strFunction, strParam);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void HandleError(String strClass, String strFunction, String strError) {
        this.CallJSFunction("handleError", new String[]{strClass, strFunction, strError});
    }
}

